// Copyright (C) 2017 Klaralvdalens Datakonsult AB (KDAB).
// SPDX-License-Identifier: LicenseRef-Qt-Commercial
#ifndef QT3DCORE_QTICKCLOCK_P_H
#define QT3DCORE_QTICKCLOCK_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists for the convenience
// of other Qt classes.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

#include <Qt3DCore/qt3dcore_global.h>
#include <QtCore/QElapsedTimer>
#include <private/qglobal_p.h>

QT_BEGIN_NAMESPACE

namespace Qt3DCore {

class QTickClock
{
public:
    QTickClock();

    void setTickFrequency(float frequency);

    void start();
    void reset();

    qint64 waitForNextTick();

private:
    QElapsedTimer m_timer;
    qint64 m_tickInterval;
    qint64 m_time;
};

} // namespace Qt3DCore

QT_END_NAMESPACE

#endif // QT3DCORE_QTICKCLOCK_P_H
